'******************************** Reciprocal Counter ************************************
'
' Measure Input_count from 1 Hz - 100 kHz with millisecond resolution.
' Uses Arduino Nano ATMega328P
'



$regfile = "m328pdef.dat"                                   ' Chip description
$hwstack = 50                                               ' make sure stacks big enough
$swstack = 50
$framesize = 50
$crystal = 16000000                                         ' 16 MHz crystal on NANO

Ddrb = &B11_0000                                            ' 0-3 are CAP switches
Portb = &B11_1111

Ddrc = &B0000_1111
Portc = &B0000_1000

Ddrd = &B0000_0100
Portd = &B1111_1111

$lib "glcdSSD1306-I2C.lib"
Config Graphlcd = Custom , Cols = 128 , Rows = 64 , Lcdname = "SSD1306"
Config Timer2 = Timer , Prescale = 1024
Setfont Font16x16
Config Adc = Single , Prescaler = Auto , Reference = Avcc   ' Use 5V ref

$baud = 38400
Config Int1 = Falling
Config Scl = Portc.5                                        ' used i2c pins
Config Sda = Portc.4
I2cinit


Enable Int1
' Enable Timer2
Enable Interrupts



Dim Frequency As Double
Dim Temp1 As Double
Dim Temp3 As Double
Dim Temp4 As Byte

Dim Reference_count As Double                               'Double                               'Double
Dim Input_count As Double                                   'Double                                   'Double
Dim First_byte As Byte
Dim Second_byte As Byte                                     'Double
Dim Third_byte As Byte                                      'Double
Dim Fourth_byte As Byte
Dim Count_0 As Double
Dim Count_1 As Double
Dim Count_2 As Double                                       'Long
Dim Count_3 As Double

Dim Temp2 As Dword
Dim Display_0 As Dword
Dim Display_1 As Dword
Dim Display_2 As Dword
Dim Display_3 As Dword
Dim Display_reference As Dword
Dim Display_input As Dword

Dim Gate_time As Word
Dim Voltage As Word
Dim Volts As Word
Dim Mv As Word
Dim Switch As Word
Dim Previous_switch As Word
Dim Hertz As Long
Dim Previous_hertz As Long
Dim Previous_millihertz As Long
Dim Millihertz As Long
Dim Display_freq As Dword
Dim Mhz As Long
Dim Khz As Long
Dim Millihz As Long


Dim Select_register As Byte
Dim Select_time As Byte

Dim High_bit As Bit
Dim Count_ended As Bit


Cr Alias &H0D
Counter_clear Alias Portb.4
Count_start Alias Portb.5
10mhz_count Alias Portd.2
Signal_count Alias Portc.3
R_clock Alias Portc.2
Sel0 Alias Portc.0
Sel1 Alias Portc.1


   Waitms 100

Splash_screen:
    Lcdat 1 , 1 , "Reciproc" , 2
    Lcdat 3 , 1 , "Counter " , 2
    Lcdat 5 , 1 , "Ver 3.1 " , 2
    Lcdat 7 , 1 , "Apr 2023" , 2

   Print "Reciprocal Counter Ver. 2.0" ; Chr(cr);


   Wait 1
                                            ' allow to stabilise
    Lcdat 1 , 1 , "  Freq  " , 2
    Lcdat 3 , 1 , "        " , 2
    Lcdat 5 , 1 , "        " , 2
    Lcdat 7 , 1 , "        " , 2

 Input_count = 0
 Reference_count = 1
 Frequency = 0

                                          'initial clear

 Main:

  Gosub Read_switch
  Gosub Check_battery
  Counter_clear = 0                                         ' pulse clear to counters
  Waitus 5
  Counter_clear = 1
  If Switch = 1 Then Gosub One_second
  If Switch = 2 Then Gosub Tenth_second
  If Switch = 0 Then Gosub Five_seconds
  Waitms 100
  Gosub Read_counters
  Gosub Calculate_frequency
  Waitms 200


   Goto Main

' Gate times according to switch

 One_second:
   Count_start = 1
   Wait 1
   Count_start = 0
   Return


Five_seconds:
   Count_start = 1
   Wait 5
   Count_start = 0
   Return

Tenth_second:
   Count_start = 1
   Waitms 100
   Count_start = 0
   Return

Hold:
   Return




' ***************************************** CHECK BATTERY ****************************************
'
' Read battery voltage on ADC6 and put on bottom line.
' 0-1023 corresponds to 0-5000 mV
' Display as BT=3.1V
'

Check_battery:
'   Gosub Read_reference_count
   Voltage = Getadc(6)
   Voltage = Voltage * 10
   Voltage = Voltage / 220
   Volts = Voltage / 10
   Mv = Voltage Mod 10
   Lcdat 7 , 1 , "Bat=" ; Volts ; "." ; Mv ; "V" , 2
 '  Print " Battery = " ; Volts ; "." ; Mv ; "V"             ' ; Chr(cr);
    Return

' Switch is a 3 position toggle on ADC7. Returns switch=0 in bottom
' switch=2 middle and switch=1 in top.

Read_switch:
   Switch = Getadc(7)
   Switch = Switch / 450                                    ' change from 1024 max to 10 max
   If Switch <> Previous_switch Then Print "Switch = " ; Switch ; Chr(cr);

   Previous_switch = Switch
  ' If Switch = 1 Then Gosub One_second_gate
  ' If Switch = 2 Then Gosub Tenth_second_gate
  ' If Switch = 0 Then Gosub Five_second_gate
      Return


' ********************************* GATE TIMES **********************************************
'
' Timer 2 is started for giving different gate times.

 One_second_gate:
   Timer2 = 65536 - 15625
   Count_start = 1                                          ' open gate
   Return

Tenth_second_gate:
   Timer2 = 65536 - 1563
   Count_start = 1                                          ' open gate
   Return


Five_second_gate:
   Timer2 = 1
   Count_start = 1                                          ' open gate
   Return

' ********************************* INT1 **************************************************
'
' On INT1 turn off Count_start

End_count:
   Count_start = 0
   Count_ended = 1
   Return

' *************************************** READ COUNTERS *************************************

'

Read_counters:

   Count_ended = 0                                          'reset flag
   R_clock = 1                                              ' pulse to counters
   Waitus 1
   R_clock = 0
   Gosub Read_input
   Gosub Read_reference_count
    Return



 Read_input:

   Signal_count = 0                                         'Lower enable on 74HC139
   10mhz_count = 1
   Gosub Read_four_bytes

   Sel0 = 0
   Sel1 = 0
   Input_count = Count_0
   Input_count = Input_count + Count_1
   Input_count = Input_count + Count_2
   Input_count = Input_count + Count_3

   Signal_count = 1
   Display_input = Input_count
   Print "Input count = " ; Display_input ; " " ; Chr(cr);
   Return



Read_reference_count:

   Signal_count = 1                                         'Lower enable on 74HC139
   Waitus 10
   10mhz_count = 0

   Gosub Read_four_bytes
 '  Count_3 = 256 * 65536
   Sel0 = 0
   Sel1 = 0
   Reference_count = Count_0
   Reference_count = Reference_count + Count_1
   Reference_count = Reference_count + Count_2
   Reference_count = Reference_count + Count_3
   10mhz_count = 1
   Display_reference = Reference_count
   Print "Reference count = " ; Display_reference ; Chr(cr);
   Return


' **************************************** READ THREE BYTES ************************************




Read_four_bytes:

   Sel0 = 0
   Sel1 = 0
   Temp4 = Pinb
   First_byte = Temp4 And &H000F                            ' lower 4 bits
   Temp4 = Pind
   Temp4 = Temp4 And &H00F0                                 ' upper 4 bits
   First_byte = First_byte Or Temp4
   Count_0 = First_byte


   Sel0 = 1
   Sel1 = 0
   Temp4 = Pinb
   Second_byte = Temp4 And &H000F                           ' lower 4 bits
   Temp4 = Pind
   Temp4 = Temp4 And &H00F0                                 ' upper 4 bits
   Second_byte = Second_byte Or Temp4
   Count_1 = Second_byte
   Count_1 = Count_1 * 256
   Display_1 = Count_1


   Sel0 = 0
   Sel1 = 1
   Temp4 = Pinb

   Third_byte = Temp4 And &H000F                            ' lower 4 bits
   Print "Low " ; Hex(third_byte);
   Temp4 = Pind
   Temp4 = Temp4 And &H00F0
   Print " High " ; Hex(temp4) ;                            ' upper 4 bits
   Third_byte = Third_byte Or Temp4
   Count_2 = Third_byte
   Print " Count 2 " ; Third_byte ; Chr(cr);
   Count_2 = Count_2 * 65536
   Display_2 = Count_2




Read_fourth_byte:
   Sel0 = 1
   Sel1 = 1
   Temp4 = Pinb
   Fourth_byte = Temp4 And &H000F                           ' lower 4 bits
   Temp4 = Pind
   Temp4 = Temp4 And &H00F0                                 ' upper 4 bits
   Fourth_byte = Fourth_byte Or Temp4
   Count_3 = Fourth_byte
   Count_3 = Count_3 * 65536
   Count_3 = Count_3 * 256
   Display_3 = Count_3

   Return



' ************************************** CALCULATE FREQUENCY *********************************
'
' Frequency = Input_count * 10000000/Reference_count
' Calculation takes 400 uS




Calculate_frequency:
  If Input_count = 0 Then Goto Cf_exit
  Temp3 = Input_count
  Temp3 = Temp3 * 30000000
  Temp1 = Reference_count
 ' Temp1 = 10000000
  Frequency = Temp3 / Temp1
  If Frequency > 1000000 Then Goto Above_1meg
  If Frequency > 200000 Then Goto Above_200k
  If Frequency <= 200000 Then Goto Below_200k
Cf_exit:
  Return


Above_1meg:
  Frequency = Frequency * 100
  Display_freq = Frequency
  Print "Display Freq = " ; Display_freq                    '; Chr(cr);
  Print " Frequency = " ; Frequency ; Chr(cr);
  Hertz = Display_freq / 100
  Hertz = Hertz - 1
  Millihertz = Display_freq Mod 100
  Millihertz = Millihertz * 10
  Print "Hertz = " ; Hertz ; " Millihertz = " ; Millihertz  '; Chr(cr);

  If Hertz < 9999999 Then Lcdat 3 , 1 , Hertz ; "H" , 2
  If Hertz => 10000000 Then Lcdat 3 , 1 , Hertz , 2
  Lcdat 5 , 1 , Millihertz ; "mHz  " , 2
'  Previous_hertz = Hertz
'  Previous_millihertz = Millihertz
  R_clock = 0
  High_bit = 0
  Waitms 500
  Return

Above_200k:
  Frequency = Frequency * 1000
  Display_freq = Frequency
  Print "Display Freq = " ; Display_freq ;
  Print " Frequency = " ; Frequency ; Chr(cr);
  Hertz = Display_freq / 1000
  Hertz = Hertz - 1
  Millihertz = Display_freq Mod 1000                        'correction
  Print "Hertz = " ; Hertz ; " Millihertz = " ; Millihertz  '; Chr(cr);

 ' If Hertz <> Previous_hertz Then Lcdat 3 , 1 , Hertz ; "Hz" , 2
'  If Hertz <> Previous_hertz Then Lcdat 5 , 1 , Millihertz ; "mHz  " , 2
  Previous_hertz = Hertz
  Lcdat 3 , 1 , Hertz ; "Hz" , 2
  Lcdat 5 , 1 , Millihertz ; "mHz  " , 2
  R_clock = 0
  High_bit = 0
  Waitms 500
  Return


Below_200k:
  Frequency = Frequency * 10000
  Display_freq = Frequency
  Print "Display Freq = " ; Display_freq ; Chr(cr);
 ' Print " Frequency = " ; Frequency ; Chr(cr);
  Hertz = Display_freq / 10000
  Hertz = Hertz - 1                                         'correction
  Millihertz = Display_freq Mod 10000
  Millihertz = Millihertz / 10
  Print "Hertz = " ; Hertz ; " Millihertz = " ; Millihertz  '; Chr(cr);
  Gosub Show_hertz
  'Previous_hertz = Hertz
  Lcdat 5 , 1 , Millihertz ; "mHz  " , 2
  R_clock = 0
  High_bit = 0
  Waitms 500
  Return

Show_hertz:
  If Hertz < 100 Then Lcdat 3 , 1 , Hertz ; "Hz     " , 2
  If Hertz < 1000 Then Lcdat 3 , 1 , Hertz ; "Hz    " , 2
  If Hertz < 10000 Then Lcdat 3 , 1 , Hertz ; "Hz  " , 2
  If Hertz < 100000 Then Lcdat 3 , 1 , Hertz ; "Hz " , 2
  If Hertz < 1000000 Then Lcdat 3 , 1 , Hertz ; "Hz" , 2

  Return



Too_high:
   Lcdat 3 , 1 , "TOO HIGH" , 2
   Lcdat 5 , 1 , "        " , 2
   Return





$include "font16x16.font"